/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import weka.classifiers.AbstractClassifier;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;

public class ThresholdSelectorDummyClassifier
extends AbstractClassifier {
    private static final long serialVersionUID = -2040984810834943903L;
    private double[] m_Preds;
    private int m_Pos;

    public ThresholdSelectorDummyClassifier(double[] preds) {
        this.m_Preds = new double[preds.length];
        int i = 0;
        while (i < preds.length) {
            this.m_Preds[i] = preds[i];
            ++i;
        }
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.enableAllAttributes();
        result.disable(Capabilities.Capability.STRING_ATTRIBUTES);
        result.disable(Capabilities.Capability.RELATIONAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        return result;
    }

    @Override
    public void buildClassifier(Instances train) {
    }

    @Override
    public double[] distributionForInstance(Instance test) throws Exception {
        double[] result = new double[test.numClasses()];
        int pred = 0;
        result[pred] = this.m_Preds[this.m_Pos];
        double residual = (1.0 - result[pred]) / (double)(result.length - 1);
        int i = 0;
        while (i < result.length) {
            if (i != pred) {
                result[i] = residual;
            }
            ++i;
        }
        this.m_Pos = (this.m_Pos + 1) % this.m_Preds.length;
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }
}

